-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- OptionsRow Library for METRO QUAD
-------------------------------------------------------------------------------------------------------------------
local s = THEME:GetString('OptionNames','Start') .. " "

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Speed Mods (X / C / M)
-------------------------------------------------------------------------------------------------------------------
function OptionRowPlayerInfo()
	local t = {
		Name = "OptionRowPlayerInfo",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'ACHIEVEMENTS' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				MetroQuad.Global.Achievements.Player = pn
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenAchievements")
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Speed Mods (X / C / M)
-------------------------------------------------------------------------------------------------------------------
function OptionRowSpeedMods()
	local t = {
		Name = "OptionRowSpeedMods",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'BEAT SPACING', s..'TIME SPACING', s..'MAX SPACING' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				MetroQuad.Global.ModPanel.Player = pn
				MetroQuad.Global.ModPanel.SpeedMod = "X"
				MetroQuad.Global.ModPanel.SpeedMaxValue = 20
				SCREENMAN:AddNewScreenToTop("ScreenSpeedModPanel")
			end
			if list[2] then
				MetroQuad.Global.ModPanel.Player = pn
				MetroQuad.Global.ModPanel.SpeedMod = "C"
				MetroQuad.Global.ModPanel.SpeedMaxValue = 1500
				SCREENMAN:AddNewScreenToTop("ScreenSpeedModPanel")
			end
			if list[3] then
				MetroQuad.Global.ModPanel.Player = pn
				MetroQuad.Global.ModPanel.SpeedMod = "M"
				MetroQuad.Global.ModPanel.SpeedMaxValue = 1500
				SCREENMAN:AddNewScreenToTop("ScreenSpeedModPanel")
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: NoteSkins
-------------------------------------------------------------------------------------------------------------------
function OptionRowNoteSkins()
	local Noteskins = NOTESKIN:GetNoteSkinNames()
	local t = {
		Name = "OptionRowNoteSkins",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = Noteskins,
		LoadSelections = function(self, list, pn)
			local userNoteSkin = GAMESTATE:GetPlayerState(pn):GetCurrentPlayerOptions():NoteSkin() or "Default"
			local i = FindInTable(userNoteSkin, Noteskins) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			local State = GAMESTATE:GetPlayerState(pn);
			local Options = State:GetPlayerOptionsString(0)
			for i=1,#list do
				if list[i] then sSave = Noteskins[i] State:SetPlayerOptions(0, Options .. ", " .. sSave) end
			end
			MESSAGEMAN:Broadcast("NoteSkinChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: NoteSize
-------------------------------------------------------------------------------------------------------------------
function OptionRowNoteSize()
	local t = {
		Name = "OptionRowNoteSize",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'ENTER NOTE SIZE', s..'SET -10% NOTE SIZE', s..'SET -20% NOTE SIZE', s..'SET -30% NOTE SIZE', s..'SET -40% NOTE SIZE', s..'SET -50% NOTE SIZE', s..'SET -60% NOTE SIZE', s..'SET -70% NOTE SIZE',
			s..'SET -80% NOTE SIZE', s..'SET -90% NOTE SIZE', s..'SET -100% NOTE SIZE', s..'SET -110% NOTE SIZE', s..'SET -120% NOTE SIZE', s..'SET -130% NOTE SIZE', s..'SET -140% NOTE SIZE', s..'SET -150% NOTE SIZE' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			local State = GAMESTATE:GetPlayerState(pn);
			local Options = State:GetPlayerOptionsString(0)
			
			if list[1] then MetroQuad.Global.ModPanel.Player = pn SCREENMAN:AddNewScreenToTop("ScreenNoteSizeModPanel") end
			if list[2] then State:SetPlayerOptions(0, Options .. ", 10% Mini") end
			if list[3] then State:SetPlayerOptions(0, Options .. ", 20% Mini") end
			if list[4] then State:SetPlayerOptions(0, Options .. ", 30% Mini") end
			if list[5] then State:SetPlayerOptions(0, Options .. ", 40% Mini") end
			if list[6] then State:SetPlayerOptions(0, Options .. ", 50% Mini") end
			if list[7] then State:SetPlayerOptions(0, Options .. ", 60% Mini") end
			if list[8] then State:SetPlayerOptions(0, Options .. ", 70% Mini") end
			if list[9] then State:SetPlayerOptions(0, Options .. ", 80% Mini") end
			if list[10] then State:SetPlayerOptions(0, Options .. ", 90% Mini") end
			if list[11] then State:SetPlayerOptions(0, Options .. ", 100% Mini") end
			if list[12] then State:SetPlayerOptions(0, Options .. ", 110% Mini") end
			if list[13] then State:SetPlayerOptions(0, Options .. ", 120% Mini") end
			if list[14] then State:SetPlayerOptions(0, Options .. ", 130% Mini") end
			if list[15] then State:SetPlayerOptions(0, Options .. ", 140% Mini") end
			if list[16] then State:SetPlayerOptions(0, Options .. ", 150% Mini") end
			MESSAGEMAN:Broadcast("NoteSizeChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ScreenFilter
-------------------------------------------------------------------------------------------------------------------
function OptionRowScreenFilter()
	local t = {
		Name="ScreenFilter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'Off', s..'10%', s..'20%', s..'30%', s..'40%', s..'50%', s..'60%', s..'70%', s..'80%', s..'90%', s..'100%' },
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			local filterValue = getenv("ScreenFilter"..pName)
			if filterValue ~= nil then
				local val = scale(tonumber(filterValue),0,1,1,#list)
				list[val] = true
			else
				setenv("ScreenFilter"..pName,0)
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = scale(i,1,#list,0,1)
						setenv("ScreenFilter"..pName,val)
						found = true
						MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ScreenFilter = string.format("%.1f",val)
						MESSAGEMAN:Broadcast("ScreenFilterChanged")
					end
				end
			end
		end,
	};
	setmetatable(t, t)
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Aceleration Menu / Boost Effect
-------------------------------------------------------------------------------------------------------------------
function OptionRowBoost()
	local t = {
		Name = "OptionRowBoost",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'SET TO OFF', s..'25% Boost', s..'50% Boost', s..'75% Boost', s..'100% Boost', s..'125% Boost', s..'150% Boost', s..'175% Boost', s..'200% Boost', s..'225% Boost', s..'250% Boost', s..'275% Boost',
			s..'300% Boost', s..'325% Boost', s..'350% Boost', s..'375% Boost' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				local State = GAMESTATE:GetPlayerState(pn);
				local Options = State:GetPlayerOptionsString(0)
				State:SetPlayerOptions(0, Options..", 0% Boost");
				SCREENMAN:SystemMessage("Boost Mod set to OFF.")
			end
			for i = 1,15 do
				if list[i+1] then
					local State = GAMESTATE:GetPlayerState(pn);
					local Options = State:GetPlayerOptionsString(0)
					State:SetPlayerOptions(0, Options..", "..(i*25).."% Boost");
					SCREENMAN:SystemMessage("Boost Mod set to "..(i*25).."% Boost.")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Aceleration Menu / Reverse Boost Effect
-------------------------------------------------------------------------------------------------------------------
function OptionRowReverseBoost()
	local t = {
		Name = "OptionRowBrake",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'SET TO OFF', s..'-25% Reverse Boost', s..'-50% Reverse Boost', s..'-75% Reverse Boost', s..'-100% Reverse Boost', s..'-125% Reverse Boost', s..'-150% Reverse Boost', s..'-175% Reverse Boost',
			s..'-200% Reverse Boost', s..'-225% Reverse Boost', s..'-250% Reverse Boost', s..'-275% Reverse Boost', s..'-300% Reverse Boost', s..'-325% Reverse Boost', s..'-350% Reverse Boost' , s..'-375% Reverse Boost' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				local State = GAMESTATE:GetPlayerState(pn);
				local Options = State:GetPlayerOptionsString(0)
				State:SetPlayerOptions(0, Options..", 0% Boost");
				SCREENMAN:SystemMessage("Reverse Boost Mod set to OFF.")
			end
			for i = 1,15 do
				if list[i+1] then
					local State = GAMESTATE:GetPlayerState(pn);
					local Options = State:GetPlayerOptionsString(0)
					State:SetPlayerOptions(0, Options..", "..(i*25).."% Boost");
					SCREENMAN:SystemMessage("Reverse Boost Mod set to -"..(i*25).."% Boost.")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Aceleration Menu / Brake Effect
-------------------------------------------------------------------------------------------------------------------
function OptionRowBrake()
	local t = {
		Name = "OptionRowBrake",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'SET TO OFF', s..'25% Brake', s..'50% Brake', s..'75% Brake', s..'100% Brake', s..'125% Brake', s..'150% Brake', s..'175% Brake', s..'200% Brake', s..'225% Brake', s..'250% Brake', s..'275% Brake',
			s..'300% Brake', s..'325% Brake', s..'350% Brake', s..'375% Brake' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				local State = GAMESTATE:GetPlayerState(pn);
				local Options = State:GetPlayerOptionsString(0)
				State:SetPlayerOptions(0, Options..", 0% Brake");
				SCREENMAN:SystemMessage("Brake Mod set to OFF.")
			end
			for i = 1,15 do
				if list[i+1] then
					local State = GAMESTATE:GetPlayerState(pn);
					local Options = State:GetPlayerOptionsString(0)
					State:SetPlayerOptions(0, Options..", "..(i*25).."% Brake");
					SCREENMAN:SystemMessage("Brake Mod set to "..(i*25).."% Brake.")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: AutoRestart
-------------------------------------------------------------------------------------------------------------------
function EnableAutoRestartWithButton()
	local t = {
		Name = "AutoRestartWithButton",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On', 'Off' },
		LoadSelections = function(self, list, pn)
			list[2] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then MetroQuad.Global.MiscOptions.AutoRestartWithButton = "On" end
			if list[2] then MetroQuad.Global.MiscOptions.AutoRestartWithButton = "Off" end
			MESSAGEMAN:Broadcast("AutoRestartChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: PlayerStats
-------------------------------------------------------------------------------------------------------------------
function VisiblePlayerStats()
	local visible = { 'On','Off' }
	local t = {
		Name = "PlayerStats",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = visible,
		LoadSelections = function(self, list, pn)
			local userPlayerStats = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerStats
			local i = FindInTable(userPlayerStats, visible) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#visible do
				if list[i] then sSave = visible[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerStats = sSave
			MESSAGEMAN:Broadcast("PlayerStatsChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: GraphDisplay
-------------------------------------------------------------------------------------------------------------------
function VisibleGraphDisplay()
	local visible = { 'On','Off' }
	local t = {
		Name = "GraphDisplay",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = visible,
		LoadSelections = function(self, list, pn)
			local userGP = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.GraphDisplay
			local i = FindInTable(userGP, visible) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#visible do
				if list[i] then sSave = visible[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.GraphDisplay = sSave
			MESSAGEMAN:Broadcast("GraphDisplayChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: SubtractiveScoring (Thanks dbk2 )
-------------------------------------------------------------------------------------------------------------------
function OptionRowSubtractiveScoring()
	local options = { "On", "Off" }
	local t = {
		Name = "OptionRowSubtractiveScoring",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			local userSubtractiveScoring = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring
			local i = FindInTable(userSubtractiveScoring, options) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#options do
				if list[i] then sSave = options[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring = sSave
			MESSAGEMAN:Broadcast("SubtractiveScoringChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: NotesPerSecond
-------------------------------------------------------------------------------------------------------------------
function VisibleNPS()
	local visible = { 'On','Off' }
	local t = {
		Name = "NPS",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = visible,
		LoadSelections = function(self, list, pn)
			local userNPS = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.NPS
			local i = FindInTable(userNPS, visible) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#visible do
				if list[i] then sSave = visible[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.NPS = sSave
			MESSAGEMAN:Broadcast("NotesPerSecondChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ColumnFlashOnMiss (Thanks dbk2 )
-------------------------------------------------------------------------------------------------------------------
function OptionRowColumnFlashed()
	local options = { "Off", "All", "Perfect", "Great", "Good", "Bad", "Miss", }
	local t = {
		Name = "OptionRowColumnFlashed",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			local userColumnFlashed = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ColumnFlashed
			local i = FindInTable(userColumnFlashed, options) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#options do
				if list[i] then
					sSave = options[i]
				end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ColumnFlashed = sSave
			MESSAGEMAN:Broadcast("FlashedColumnChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: MeasureCounter (Thanks dbk2 & Kyzentun)
-------------------------------------------------------------------------------------------------------------------
function OptionRowMeasureCounter()
	local options = { "None", "8th", "12th", "16th", "24th", "32nd" }
	local t = {
		Name = "OptionRowMeasureCounter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			local userMeasureCounter = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.MeasureCounter
			local i = FindInTable(userMeasureCounter, options) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#options do
				if list[i] then sSave = options[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.MeasureCounter = sSave
			MESSAGEMAN:Broadcast("MeasureCounterChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Custom SavedModsSlots
-------------------------------------------------------------------------------------------------------------------
function OptionRowCustomSavedModsSlots()
	local t = {
		Name = "OptionRowCustomSavedModsSlots",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'CREATE NEW SLOT', s..'REMOVE EXISTING SLOT', s..'RELOAD EXISTING SLOTS' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
				local searchSettings = {
					Question = "Enter New Slot name:",
					MaxInputLength = 255,
					OnOK = function(answer)
						CreateFile(answer,".cfg","#EMPTY","SavedModsSlots")
						SCREENMAN:SystemMessage("You have created a new Slot to save Player Options.")
					end,
				};
				SCREENMAN:GetTopScreen():Load(searchSettings);
			end
			if list[2] then
				SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
				local searchSettings = {
					Question = "For security, Enter Mods Slot manually:",
					MaxInputLength = 255,
					OnOK = function(answer)
						local slotExist = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."/Other/SavedModsSlots/"..answer..".cfg")
						
						if slotExist then
							WriteFile(answer..".cfg","#DELETED","SavedModsSlots")
							SCREENMAN:SystemMessage("Existing Mods Slot removed successfully.")
						else
							SCREENMAN:SystemMessage("Mods Slot not found!")
						end
					end,
				};
				SCREENMAN:GetTopScreen():Load(searchSettings);
			end
			if list[3] then
				SCREENMAN:SystemMessage("Existing Mods Slots reloaded successfully!") SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
			end
		end
	}
	return t
end

function GetChoices()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SavedModsSlots/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub(".cfg","")
		
		local text = LoadFile(dir,"SavedModsSlots")
		if text == "#DELETED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end
	
	--SCREENMAN:SystemMessage("Files:"..#files)
	return options
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Custom SavedModsSlots
-------------------------------------------------------------------------------------------------------------------
function OptionRowLoadModsSlot()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SavedModsSlots/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub(".cfg","")
		
		local text = LoadFile(dir,"SavedModsSlots")
		if text == "#DELETED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end

	local t = {
		Name = "OptionRowLoadModsSlot",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = GetChoices(),
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] then
					if options[i] == "EMPTY LIST" then
						-- DO NOTHING
					else
						local slot = LoadFile(options[i]:gsub(s,"")..".cfg","SavedModsSlots")
						if slot ~= "#EMPTY" then
						
							-- Player Options
							local State = GAMESTATE:GetPlayerState(pn);
							State:SetPlayerOptions(0, slot)
							MESSAGEMAN:Broadcast("SpeedModChanged")
							MESSAGEMAN:Broadcast("NoteSizeChanged")
							MESSAGEMAN:Broadcast("NoteSkinChanged")
							
							-- Since the others features such as GraphDisplay, MeasureCounter aren't part of the PlayerOptions, we gonna added them manually if selected.
							-- AutoRestart
							local isAutoRestart = string.match(slot,"#AutoRestart")
							if isAutoRestart then MetroQuad.Global.MiscOptions.AutoRestartWithButton = "On" end
							MESSAGEMAN:Broadcast("AutoRestartChanged")
							
							-- PlayerStats
							local isPlayerStats = string.match(slot,"#PlayerStats")
							if isPlayerStats then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerStats = "On" end
							MESSAGEMAN:Broadcast("PlayerStatsChanged")
							
							-- GraphDisplay
							local isGraphDisplay = string.match(slot,"#GraphDisplay")
							if isGraphDisplay then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.GraphDisplay = "On" end
							MESSAGEMAN:Broadcast("GraphDisplayChanged")
							
							-- MeasureCounter
							local isMeasureCounter = string.match(slot,"#MeasureCounter%-[%d]+")
							local MeasureCounterChoice = string.gsub(isMeasureCounter or "","#MeasureCounter%-","")
							if isMeasureCounter then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.MeasureCounter = FormatNumberAndSuffix(tonumber(MeasureCounterChoice)) end
							MESSAGEMAN:Broadcast("MeasureCounterChanged")
							
							-- SubtractiveScoring
							local isSubtractiveScoring = string.match(slot,"#SubtractiveScoring")
							if isSubtractiveScoring then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring = "On" end
							MESSAGEMAN:Broadcast("SubtractiveScoringChanged")
							
							-- NotesPerSecond
							local isNotesPerSecond = string.match(slot,"#NotesPerSecond")
							if isNotesPerSecond then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.NPS = "On" end
							MESSAGEMAN:Broadcast("NotesPerSecondChanged")
							
							-- CommifiedCombo
							local isCommifiedCombo = string.match(slot,"#CommifiedCombo")
							if isCommifiedCombo then WriteFile("CommifyCombo"..ToEnumShortString(pn)..".cfg","On","Settings") end
							MESSAGEMAN:Broadcast("CommifiedComboChanged")
							
							-- Vocalization
							local isVocalization = string.match(slot,"#Vocalization%-[%w]+")
							local VocalizationChoice = string.gsub(isVocalization or "","#Vocalization%-","")
							if isVocalization then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.Vocalization = VocalizationChoice end
							MESSAGEMAN:Broadcast("VocalizationScoreChanged")
							
							-- ScreenFilter
							local isScreenFilter = string.match(slot,"#ScreenFilter%-[%d].[%d]")
							local ScreenFilterChoice = string.gsub(isScreenFilter or "","#ScreenFilter%-","")
							if isScreenFilter then setenv("ScreenFilter"..ToEnumShortString(pn),tonumber(ScreenFilterChoice)) end
							MESSAGEMAN:Broadcast("ScreenFilterChanged")
							
							-- FlashedColumn
							local isFlashedColumn = string.match(slot,"#FlashedColumn%-[%w]+")
							local FlashedColumnChoice = string.gsub(isFlashedColumn or "","#FlashedColumn%-","")
							if isFlashedColumn then MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ColumnFlashed = FlashedColumnChoice end
							MESSAGEMAN:Broadcast("FlashedColumnChanged")
							
							-- Finally, we show the SystemMessage.
							MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerOptions = slot
							MESSAGEMAN:Broadcast("ModsSlotLoaded")
							SCREENMAN:SystemMessage("\""..options[i]:gsub(s,"").."\" Mods Slot loaded successfully for "..ToEnumShortString(pn)..".")
						else
							SCREENMAN:SystemMessage("Unable to load Empty \""..options[i]:gsub(s,"").."\" Mods Slot.")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Custom SavedModsSlots
-------------------------------------------------------------------------------------------------------------------
function OptionRowAddModsToSlot()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SavedModsSlots/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub(".cfg","")
		
		local text = LoadFile(dir,"SavedModsSlots")
		if text == "#DELETED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end

	local t = {
		Name = "OptionRowAddModsToSlot",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] then
					if options[i] == "EMPTY LIST" then
						-- DO NOTHING
					else
						-- PlayerOptions
						local State = GAMESTATE:GetPlayerState(pn);
						local Options = State:GetPlayerOptionsString(0)
						
						-- Since the others features such as GraphDisplay, MeasureCounter aren't part of the PlayerOptions, we gonna added them manually if selected.
						-- AutoRestart
						local AutoRestart = MetroQuad.Global.MiscOptions.AutoRestartWithButton
						local ModAutoRestart = ""
						if AutoRestart == "On" then ModAutoRestart = " #AutoRestart," end
						
						-- PlayerStats
						local PlayerStats = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerStats
						local ModPlayerStats = ""
						if PlayerStats == "On" then ModPlayerStats = " #PlayerStats," end
						
						-- GraphDisplay
						local GraphDisplay = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.GraphDisplay
						local ModGraphDisplay = ""
						if GraphDisplay == "On" then ModGraphDisplay = " #GraphDisplay," end
						
						-- MeasureCounter
						local MeasureCounter = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.MeasureCounter
						local ModMeasureCounter = ""
						if MeasureCounter ~= "None" then ModMeasureCounter = " #MeasureCounter-"..string.match(MeasureCounter,"[%d]+").."," end
						
						-- SubtractiveScoring
						local SubtractiveScoring = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring
						local ModSubtractiveScoring = ""
						if SubtractiveScoring == "On" then ModSubtractiveScoring = " #SubtractiveScoring," end
						
						-- NotesPerSecond
						local NotesPerSecond = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.NPS
						local ModNotesPerSecond = ""
						if NotesPerSecond == "On" then ModNotesPerSecond = " #NotesPerSecond," end
						
						-- CommifiedCombo
						local CommifiedCombo = LoadFile("CommifyCombo"..ToEnumShortString(pn)..".cfg","Settings")
						local ModCommifiedCombo = ""
						if CommifiedCombo == "On" then ModCommifiedCombo = " #CommifiedCombo," end
						
						-- Vocalization
						local Vocalization = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.Vocalization
						local ModVocalization = ""
						if Vocalization ~= "None" then ModVocalization = " #Vocalization-"..Vocalization.."," end
						
						-- ScreenFilter
						local ScreenFilter = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ScreenFilter
						local ModScreenFilter = ""
						if ScreenFilter ~= nil then ModScreenFilter = " #ScreenFilter-"..ScreenFilter.."," end
						
						-- FlashedColumn
						local FlashedColumn = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.ColumnFlashed
						local ModFlashedColumn = ""
						if FlashedColumn ~= "Off" then ModFlashedColumn = " #FlashedColumn-"..FlashedColumn.."," end
						
						WriteFile(options[i]:gsub(s,"")..".cfg",Options..","..ModAutoRestart..ModPlayerStats..ModGraphDisplay..ModMeasureCounter..ModSubtractiveScoring..ModNotesPerSecond..ModCommifiedCombo..ModVocalization..ModScreenFilter..ModFlashedColumn,"SavedModsSlots")
						SCREENMAN:SystemMessage("The current "..ToEnumShortString(pn).." Mods has been added to the \""..options[i]:gsub(s,"").."\" Mods Slot.")
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: SongsList
-------------------------------------------------------------------------------------------------------------------
function OptionRowCreateSongsList()
	local t = {
		Name = "OptionRowCreateSongsList",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'CREATE NEW LIST', s..'REMOVE SONGS LIST', s..'RELOAD SONGS LIST' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
				local searchSettings = {
					Question = "Enters New file name",
					MaxInputLength = 255,
					OnOK = function(answer)
						local f = RageFileUtil.CreateRageFile()
						
						-- We creates this file that will works only as a Choice for the OptionRow.
						f:Open((THEME:GetCurrentThemeDirectory().."/Other/SongsList/"..answer..".lua"):gsub("new",""),2)
						f:Write("#EMPTY")
						f:Close()
						
						-- Creates the 2nd file where it will be loaded later.
						f:Open((THEME:GetCurrentThemeDirectory().."/Other/SongManager "..answer..".txt"):gsub("new",""),2)
						f:Write("--")
						f:Close()
						f:destroy()
						SCREENMAN:SystemMessage("Songs List created succesfully. Reload Songs List!")
					end,
				};
				SCREENMAN:GetTopScreen():Load(searchSettings);
			end
			if list[2] then
				SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
				local searchSettings = {
					Question = "For security, enters Songs List name manually",
					MaxInputLength = 255,
					OnOK = function(answer)
						local f = RageFileUtil.CreateRageFile()
						local luaExist = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."/Other/SongsList/"..answer..".lua")
						local txtExist = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."/Other/SongManager "..answer..".txt")
						
						if luaExist and txtExist then
							f:Open((THEME:GetCurrentThemeDirectory().."/Other/SongsList/"..answer..".lua"):gsub("new",""),2)
							f:Write("#LISTREMOVED")
							f:Close()
							
							f:Open((THEME:GetCurrentThemeDirectory().."/Other/SongManager "..answer..".txt"):gsub("new",""),2)
							f:Write("#LISTREMOVED")
							f:Close()
							f:destroy()
							SCREENMAN:SystemMessage("Songs List removed succesfully. Reload Songs List!")
						else
							SCREENMAN:SystemMessage("Songs List has not been found.")
						end
					end,
				};
				SCREENMAN:GetTopScreen():Load(searchSettings);
			end
			if list[3] then
				SCREENMAN:SystemMessage("Songs List reloaded successfully!") SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: MUSIC WHEEL
-------------------------------------------------------------------------------------------------------------------
function OptionRowAddSongFromSelection()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SongsList/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub(".lua","")
		
		local f = RageFileUtil.CreateRageFile()
		f:Open(THEME:GetCurrentThemeDirectory().."Other/SongsList/"..dir,1)
		local text = f:Read()
		f:Close()
		f:destroy()
		
		if text == "#LISTREMOVED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end

	local t = {
		Name = "OptionRowAddSongFromSelection",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] then
					if options[i] == "EMPTY LIST" then

					else
						if GetCurrentSong() then
							local f = RageFileUtil.CreateRageFile()
							local sName = GetCurrentSong():GetDisplayMainTitle()
							local Song = GAMESTATE:GetCurrentSong():GetSongDir():gsub("/AdditionalSongs","")
							local clearSong = regexEncode(Song)
							
							-- We extract the content of the lua file for a free slot.
							f:Open(THEME:GetCurrentThemeDirectory().."Other/SongsList/"..options[i]:gsub(s,"")..".lua",1)
							local text = f:Read()
							local SongExist = string.match(text,clearSong)
							f:Close()
							
							if SongExist then
								SCREENMAN:SystemMessage("Song \""..sName.."\" already exist on list \""..options[i]:gsub(s,"").."\".")
							else
								f:Open(THEME:GetCurrentThemeDirectory().."Other/SongManager "..options[i]:gsub(s,"")..".txt",1)
								local oldText = f:Read()
								f:Close()
								
								f:Open((THEME:GetCurrentThemeDirectory().."Other/SongsList/"..options[i]:gsub(s,"")..".lua"):gsub("new",""),2)
								f:Write(text:gsub("#EMPTY",clearSong.."\n#EMPTY"))
								f:Close()
								
								f:Open((THEME:GetCurrentThemeDirectory().."Other/SongManager "..options[i]:gsub(s,"")..".txt"):gsub("new",""),2)
								f:Write(oldText.."\n"..Song)
								f:Close()
								f:destroy()
								SCREENMAN:SystemMessage("Song \""..sName.."\" has been added to list \""..options[i]:gsub(s,"").."\" succesfully.")
							end
						else
							SCREENMAN:SystemMessage("Unable to add song to list.")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: MUSIC WHEEL
-------------------------------------------------------------------------------------------------------------------
function OptionRowDeleteSongFromSelection()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SongsList/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub(".lua","")
		
		local f = RageFileUtil.CreateRageFile()
		f:Open(THEME:GetCurrentThemeDirectory().."Other/SongsList/"..dir,1)
		local text = f:Read()
		f:Close()
		f:destroy()
		
		if text == "#LISTREMOVED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end

	local t = {
		Name = "OptionRowDeleteSongFromSelection",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] then
					if options[i] == "EMPTY LIST" then

					else
						if GetCurrentSong() then
							local f = RageFileUtil.CreateRageFile()
							local sName = GetCurrentSong():GetDisplayMainTitle()
							local Song = GAMESTATE:GetCurrentSong():GetSongDir():gsub("/AdditionalSongs","")
							local clearSong = regexEncode(Song)
							
							-- We extract the content of the lua file for a free slot.
							f:Open(THEME:GetCurrentThemeDirectory().."Other/SongsList/"..options[i]:gsub(s,"")".lua",1)
							local text = f:Read()
							local SongExist = string.match(text,clearSong)
							f:Close()
							
							if SongExist then
								f:Open(THEME:GetCurrentThemeDirectory().."Other/SongManager "..options[i]:gsub(s,"")..".txt",1)
								local oldText = f:Read()
								f:Close()
								
								f:Open((THEME:GetCurrentThemeDirectory().."Other/SongsList/"..options[i]:gsub(s,"")..".lua"):gsub("new",""),2)
								f:Write(text:gsub(clearSong,"--"))
								f:Close()
								
								f:Open((THEME:GetCurrentThemeDirectory().."Other/SongManager "..options[i]:gsub(s,"")..".txt"):gsub("new",""),2)
								f:Write(oldText:gsub(clearSong,"--"))
								f:Close()
								f:destroy()
								SCREENMAN:SystemMessage("Song \""..sName.."\" has been deleted from list \""..options[i]:gsub(s,"").."\" succesfully.")
							else
								SCREENMAN:SystemMessage("Song \""..sName.."\" doesn't exist on list \""..options[i]:gsub(s,"").."\".")
							end
						else
							SCREENMAN:SystemMessage("Unable to add song to list.")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: MUSIC WHEEL
-------------------------------------------------------------------------------------------------------------------
function OptionRowLoadSongsList()
	local files = FILEMAN:GetDirListing(THEME:GetCurrentThemeDirectory() .. "Other/SongsList/",false,false)
	local options = { }

	for k,dir in ipairs(files) do
		-- Dynamically fill the table.
		options[#options+1] = s..dir:gsub("%.lua","")
		
		local f = RageFileUtil.CreateRageFile()
		f:Open(THEME:GetCurrentThemeDirectory().."Other/SongsList/"..dir,1)
		local text = f:Read()
		f:Close()
		f:destroy()
		
		if text == "#LISTREMOVED" then table.remove(options,k) end
	end
	
	if #options < 1 then
		options = { "EMPTY LIST" }
	end

	local t = {
		Name = "OptionRowLoadSongsList",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] then
					if options[i] == "EMPTY LIST" then

					else
						local f = RageFileUtil.CreateRageFile()
						f:Open(THEME:GetCurrentThemeDirectory().."Other/SongManager "..options[i]:gsub(s,"")..".txt",1)
						local Text = f:Read()
						f:Close()
						f:destroy()
						
						-- We check if the list is empty or not.
						if Text ~= "#SONGSLIST" then
							SONGMAN:SetPreferredSongs(options[i]:gsub(s,""))
							SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(0)
							SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
						else
							SCREENMAN:SystemMessage("Unable to load empty list.")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Rate
-------------------------------------------------------------------------------------------------------------------
function OptionRowRate()
	local t = {
		Name = "OptionRowRate",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'Enter Manually Rate', s..'Enter BPM Based Rate', s..'Rate 1.0', s..'Rate 1.1', s..'Rate 1.2', s..'Rate 1.3', s..'Rate 1.4', s..'Rate 1.5', s..'Rate 1.6', s..'Rate 1.7', s..'Rate 1.8', s..'Rate 1.9', s..'Rate 2.0' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				MetroQuad.Global.ModPanel.Player = pn
				MetroQuad.Global.ModPanel.RateType = "Rate"
				SCREENMAN:AddNewScreenToTop("ScreenRateModPanel")
			end
			if list[2] then
				MetroQuad.Global.ModPanel.Player = pn
				MetroQuad.Global.ModPanel.RateType = "BPM"
				SCREENMAN:AddNewScreenToTop("ScreenRateModPanel")
			end
			if list[3] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.0"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.0", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[4] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.1"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.1xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.1", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[5] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.2"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.2xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.2", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[6] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.3"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.3xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.3", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[7] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.4"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.4xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.4", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[8] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.5"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.5xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.5", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[9] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.6"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.6xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.6", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[10] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.7"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.7xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.7", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[11] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.8"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.8xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.8", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[12] then
				MetroQuad.Global.MiscOptions.RateModUsed = "1.9"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "1.9xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "1.9", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
			if list[13] then
				MetroQuad.Global.MiscOptions.RateModUsed = "2.0"
				GAMESTATE:SetSongOptions("ModsLevel_Preferred", "2xMusic")
				MESSAGEMAN:Broadcast("RateModChanged",{Rate = "2.0", MeterP1 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction()), MeterP2 = string.format("%.1f",GetMeter(PLAYER_1) * RateModUpdateFunction())})
			end
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: SortOrder
-------------------------------------------------------------------------------------------------------------------
function OptionRowSortOrder()
	local t = {
		Name = "OptionRowSortOrder",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { s..'PREFERRED', s..'GROUP', s..'TITLE', s..'BPM', s..'ARTIST', s..'GENRE', s..'NOVICE METER', s..'EASY METER', s..'MEDIUM METER', s..'HARD METER', s..'EXPERT METER' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(0) SCREENMAN:SystemMessage("Sort Order changed to PREFERRED.") end
			if list[2] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(1) SCREENMAN:SystemMessage("Sort Order changed to GROUP.") end
			if list[3] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(2) SCREENMAN:SystemMessage("Sort Order changed to TITLE.") end
			if list[4] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(3) SCREENMAN:SystemMessage("Sort Order changed to BPM.") end
			if list[5] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(6) SCREENMAN:SystemMessage("Sort Order changed to ARTIST.") end
			if list[6] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(7) SCREENMAN:SystemMessage("Sort Order changed to GENRE.") end
			if list[7] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(8) SCREENMAN:SystemMessage("Sort Order changed to NOVICE METER.") end
			if list[8] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(9) SCREENMAN:SystemMessage("Sort Order changed to EASY METER.") end
			if list[9] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(10) SCREENMAN:SystemMessage("Sort Order changed to MEDIUM METER.") end
			if list[10] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(11) SCREENMAN:SystemMessage("Sort Order changed to HARD METER.") end
			if list[11] then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(12) SCREENMAN:SystemMessage("Sort Order changed to EXPERT METER.") end
			MESSAGEMAN:Broadcast("SortOrderChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Switch Game
-------------------------------------------------------------------------------------------------------------------
function OptionRowSwitchGame()
	local options = {}
	local EventMode = GAMESTATE:IsEventMode()
	local PayMode = GAMESTATE:GetCoinMode()
	
	if EventMode then
		options = { s.."DANCE" ,s.."PUMP", s.."TECHNO" }
	else	
		options = { s.."NOT AVAILABLE" }
	end

	local t = {
		Name = "OptionRowSwitchGame",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if EventMode then
				if list[1] then
					MetroQuad.Global.MiscOptions.GameChangedFromOpList = true
					GAMEMAN:SetGame("dance")
				end
				if list[2] then
					MetroQuad.Global.MiscOptions.GameChangedFromOpList = true
					GAMEMAN:SetGame("pump")
				end
				if list[3] then
					MetroQuad.Global.MiscOptions.GameChangedFromOpList = true
					GAMEMAN:SetGame("techno")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Switch Panels
-------------------------------------------------------------------------------------------------------------------
function OptionRowSwitchPanels()
	local options = {}
	local IsVersus = GetCurrentStyle():GetName() == "versus"
	local IsDance = GAMESTATE:GetCurrentGame():GetName() == "dance"
	local IsPump = GAMESTATE:GetCurrentGame():GetName() == "pump"
	local IsTechno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local CoinMode = ToEnumShortString(GAMESTATE:GetCoinMode())
	local EventMode = GAMESTATE:IsEventMode()
	
	if EventMode then
		if IsDance then
			options = { s..'Single', s..'Double', s..'Solo' }
		elseif IsPump then
			options = { s..'Single', s..'Double' }
		elseif IsTechno then
			options = { s..'Single8', s..'Double8' }
		end
	else
		options = { s.."NOT AVAILABLE" }
	end
	
	local t = {
		Name = "OptionRowSwitchPanels",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if EventMode then
				if IsDance then
					if list[1] then
						-- If you are already on Versus, we need to unjoin the opposite player and then inmediately
						-- join the player who changed of style. This to prevent an error of no sides left to join
						-- that style.
						if pn == PLAYER_1 then GAMESTATE:UnjoinPlayer(PLAYER_2) GAMESTATE:JoinPlayer(PLAYER_1) end
						if pn == PLAYER_2 then GAMESTATE:UnjoinPlayer(PLAYER_1) GAMESTATE:JoinPlayer(PLAYER_2) end
						GAMESTATE:SetCurrentStyle("Single")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
					if list[2] then
						-- If you are already on Versus, we need to unjoin the opposite player and then inmediately
						-- join the player who changed of style. This to prevent an error of no sides left to join
						-- that style.
						if pn == PLAYER_1 then GAMESTATE:UnjoinPlayer(PLAYER_2) GAMESTATE:JoinPlayer(PLAYER_1) end
						if pn == PLAYER_2 then GAMESTATE:UnjoinPlayer(PLAYER_1) GAMESTATE:JoinPlayer(PLAYER_2) end
						GAMESTATE:SetCurrentStyle("Double")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
					if list[3] then
						-- Stepmania crashes if we tried to change from Versus to Solo trying to unjoin and join players
						-- I don't know why Doubles dont crash with this way. To prevent Stepmania to crash, we will send
						-- a SystemMessage instead.
						if IsVersus then
							SCREENMAN:SystemMessage("Unable to change style to \"Solo\". Too many sides joined.")
						else
							GAMESTATE:SetCurrentStyle("Solo")
							SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
							SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
						end
					end
				end
				if IsPump then
					if list[1] then
						GAMESTATE:SetCurrentStyle("Single")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
					if list[2] then
						GAMESTATE:SetCurrentStyle("Double")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
				end
				if IsTechno then
					if list[1] then
						GAMESTATE:SetCurrentStyle("Single8")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
					if list[2] then
						GAMESTATE:SetCurrentStyle("Double8")
						SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: SurroundLife
-------------------------------------------------------------------------------------------------------------------
function SurroundLifeVisible()
	local visible = { 'Enable', 'Disable' }
	local t = {
		Name = "LifeVisible",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = visible,
		LoadSelections = function(self, list, pn)
			local userLifeVisible = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.LifeVisible
			local i = FindInTable(userLifeVisible, visible) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#visible do
				if list[i] then sSave = visible[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.LifeVisible = sSave
			MESSAGEMAN:Broadcast("SurroundLifeChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Summary Screen
-------------------------------------------------------------------------------------------------------------------
function OptionRowSummary()
	local t = {
		Name = "OptionRowSummary",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'SEE SUMMARY' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				local StageIndex = GAMESTATE:GetCurrentStageIndex()
				if StageIndex == 0 then
					SCREENMAN:SystemMessage("Unable to View Scores. You have to play at least One Song!")
				else
					SCREENMAN:GetTopScreen():SetNextScreenName("ScreenViewScores")
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Practice/Edit Options
-------------------------------------------------------------------------------------------------------------------
function OptionRowPracticeOptions()
	local t = {
		Name = "OptionRowPracticeOptions",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { s..'ENTER PRACTICE MODE', s..'ENTER EDIT MODE' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				local Song = GetCurrentSong()
				if Song then
					local TopScreen = SCREENMAN:GetTopScreen() TopScreen:SetNextScreenName("ScreenPracticeTemporaly") TopScreen:StartTransitioningScreen("SM_GoToNextScreen")
				else
					SCREENMAN:SystemMessage("Unable to enters Practice Mode. Stay over a Song and then Try Again!")
				end
			end
			if list[2] then
				local Song = GetCurrentSong()
				if Song then
					local TopScreen = SCREENMAN:GetTopScreen() TopScreen:SetNextScreenName("ScreenEditTemporaly") TopScreen:StartTransitioningScreen("SM_GoToNextScreen")
				else
					SCREENMAN:SystemMessage("Unable to enters Edit Mode. Stay over a Song and then Try Again!")
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Commify Combo
-------------------------------------------------------------------------------------------------------------------
function MQCommifyCombo()
	local t = {
		Name = "MQCommifyCombo",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'On', 'Off' },
		LoadSelections = function(self, list, pn)
			local i = LoadFile("CommifyCombo"..ToEnumShortString(pn)..".cfg","Settings") == "On" and 1 or 2
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then WriteFile("CommifyCombo"..ToEnumShortString(pn)..".cfg","On","Settings") else WriteFile("CommifyCombo"..ToEnumShortString(pn)..".cfg","Off","Settings") end
			MESSAGEMAN:Broadcast("CommifiedComboChanged")
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: VocalizationScore (from Simply Love)
-------------------------------------------------------------------------------------------------------------------
function OptionRowVocalize()
	local files = FILEMAN:GetDirListing(GetVocalizeDir() , true, false)
	local vocalizations = { "None" }
	
	for k,dir in ipairs(files) do
		vocalizations[#vocalizations+1] = dir
	end
	
	if #vocalizations > 1 then
		vocalizations[#vocalizations+1] = "Random"
		vocalizations[#vocalizations+1] = "Blender"
	end
	
	local t = {
		Name = "UserScoreVocalization",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = vocalizations,
		LoadSelections = function(self, list, pn)
			local userVocal = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.Vocalization
			local i = FindInTable(userVocal, vocalizations) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then sSave = vocalizations[i] end
			end
			MetroQuad[ToEnumShortString(pn)].ActiveModifiers.Vocalization = sSave
			MESSAGEMAN:Broadcast("VocalizationScoreChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ThemeColorChoice
-------------------------------------------------------------------------------------------------------------------
function OptionRowThemeColorChoice()
	local EventMode = GAMESTATE:IsEventMode()
	local options
	
	if EventMode == false then
		options = { 'CURRENT COLOR', s..'BLUE', s..'RED', s..'GREEN', s..'YELLOW', s..'PURPLE',s..'PINK', s..'ORANGE', s..'GRAY', s..'TEAL #1', s..'TEAL #2' }
	else
		options = { s..'SET COLOR MANUALLY', s..'BLUE', s..'RED', s..'GREEN', s..'YELLOW', s..'PURPLE', s..'PINK', s..'ORANGE', s..'GRAY', s..'TEAL #1', s..'TEAL #2' }
	end
	
	local t = {
		Name = "OptionRowThemeColorChoice",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if EventMode == true then
				if list[1] then MetroQuad.Global.ModPanel.Player = pn SCREENMAN:AddNewScreenToTop("ScreenThemeColorPanel") end
				if list[2] then WriteFile("ThemeColor.cfg",tColors[1],"Settings") end
				if list[3] then WriteFile("ThemeColor.cfg",tColors[2],"Settings") end
				if list[4] then WriteFile("ThemeColor.cfg",tColors[3],"Settings") end
				if list[5] then WriteFile("ThemeColor.cfg",tColors[4],"Settings") end
				if list[6] then WriteFile("ThemeColor.cfg",tColors[5],"Settings") end
				if list[7] then WriteFile("ThemeColor.cfg",tColors[6],"Settings") end
				if list[8] then WriteFile("ThemeColor.cfg",tColors[7],"Settings") end
				if list[9] then WriteFile("ThemeColor.cfg",tColors[8],"Settings") end
				if list[10] then WriteFile("ThemeColor.cfg",tColors[9],"Settings") end
				if list[11] then WriteFile("ThemeColor.cfg",tColors[10],"Settings") end
			else
				if list[1] then SCREENMAN:SystemMessage("The current Theme Color is: #") end
				if list[2] then WriteFile("ThemeColor.cfg",tColors[1],"Settings") end
				if list[3] then WriteFile("ThemeColor.cfg",tColors[2],"Settings") end
				if list[4] then WriteFile("ThemeColor.cfg",tColors[3],"Settings") end
				if list[5] then WriteFile("ThemeColor.cfg",tColors[4],"Settings") end
				if list[6] then WriteFile("ThemeColor.cfg",tColors[5],"Settings") end
				if list[7] then WriteFile("ThemeColor.cfg",tColors[6],"Settings") end
				if list[8] then WriteFile("ThemeColor.cfg",tColors[7],"Settings") end
				if list[9] then WriteFile("ThemeColor.cfg",tColors[8],"Settings") end
				if list[10] then WriteFile("ThemeColor.cfg",tColors[9],"Settings") end
				if list[11] then WriteFile("ThemeColor.cfg",tColors[10],"Settings") end
			end
			MESSAGEMAN:Broadcast("ThemeColorChanged")
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ThemeColorLoad
-------------------------------------------------------------------------------------------------------------------
function OptionRowThemeColorLoad()
	local options = {}
	for i = 1,16 do options[#options+1] = s..'LOAD SLOT #'..string.format("%02.f",i) end
	local t = {
		Name = "OptionRowThemeColorLoad",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			local ProfileName = PROFILEMAN:GetProfile(pn)
			for i = 1,16 do
				if list[i] then
					if PROFILEMAN:GetNumLocalProfiles() == 0 then
						local GenericSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots Generic")
						if GenericSlot == "EMPTY" then
							SCREENMAN:SystemMessage("Unable to load Slot #"..string.format("%02.f",i).." from Generic Profile.")
						else
							WriteFile("ThemeColor.cfg",ThemeSlot,"Settings")
							MESSAGEMAN:Broadcast("ThemeColorChanged")
							SCREENMAN:SystemMessage("Color \""..ThemeSlot.."\" from Slot #"..string.format("%02.f",i).." loaded succesfully.")
						end
					else
						local ThemeSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots "..ProfileName:GetDisplayName())
						if ThemeSlot == "EMPTY" then
							SCREENMAN:SystemMessage("Unable to load Slot #"..string.format("%02.f",i).." from Profile \""..ProfileName:GetDisplayName().."\".")
						else
							WriteFile("ThemeColor.cfg",ThemeSlot,"Settings")
							MESSAGEMAN:Broadcast("ThemeColorChanged")
							SCREENMAN:SystemMessage("Color \""..ThemeSlot.."\" from Slot #"..string.format("%02.f",i).." loaded succesfully.")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ThemeColorSave
-------------------------------------------------------------------------------------------------------------------
function OptionRowThemeColorSave()
	local options = {}
	for i = 1,16 do options[#options+1] = s..'SAVE SLOT #'..string.format("%02.f",i) end
	local t = {
		Name = "OptionRowThemeColorSave",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			local ProfileName = PROFILEMAN:GetProfile(pn)
			local ColorToSave = LoadFile("ThemeColor.cfg","Settings")
			for i = 1,16 do
				if list[i] then	
					if PROFILEMAN:GetNumLocalProfiles() == 0 then
						local Rewrite = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots Generic")
						if Rewrite ~= "EMPTY" then
							local topScreen = SCREENMAN:GetTopScreen();
							local screenName = topScreen:GetName();
							if screenName == "ScreenSelectMusic" then
								SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
								local searchSettings = {
									Question = "Slot already in use. Do you want to rewrite?\nYes [1] - No [2]",
									MaxInputLength = 1,
									OnOK = function(answer)
										if answer == "1" then
											WriteFile("ThemeSlot"..i..".cfg",ColorToSave,"Settings/ThemeSlots Generic")
											MESSAGEMAN:Broadcast("ThemeSlotSaved")
											SCREENMAN:SystemMessage("Color \""..ColorToSave.."\" saved on Slot #"..string.format("%02.f",i).." succesfully for Generic Profile.")
										elseif answer == "2" then
											SCREENMAN:SystemMessage("Slot #"..string.format("%02.f",i).." already in use on Generic Profile.")
										end
									end,
								};
								SCREENMAN:GetTopScreen():Load(searchSettings);
							end;
						else
							WriteFile("ThemeSlot"..i..".cfg",ColorToSave,"Settings/ThemeSlots Generic")
							MESSAGEMAN:Broadcast("ThemeSlotSaved")
							SCREENMAN:SystemMessage("Color \""..ColorToSave.."\" saved on Slot #"..string.format("%02.f",i).." succesfully for Generic Profile.")
						end
					else
						local Rewrite = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots "..ProfileName:GetDisplayName())
						if Rewrite ~= "EMPTY" then
							local topScreen = SCREENMAN:GetTopScreen();
							local screenName = topScreen:GetName();
							if screenName == "ScreenSelectMusic" then
								SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
								local searchSettings = {
									Question = "Slot already in use. Do you want to rewrite?\nYes [1] - No [2]",
									MaxInputLength = 1,
									OnOK = function(answer)
										if answer == "1" then
											WriteFile("ThemeSlot"..i..".cfg",ColorToSave,"Settings/ThemeSlots "..ProfileName:GetDisplayName())
											MESSAGEMAN:Broadcast("ThemeSlotSaved")
											SCREENMAN:SystemMessage("Color \""..ColorToSave.."\" saved on Slot #"..string.format("%02.f",i).." succesfully for Profile \""..ProfileName:GetDisplayName().."\"")
										elseif answer == "2" then
											SCREENMAN:SystemMessage("Slot #"..string.format("%02.f",i).." already in use on Profile \""..ProfileName:GetDisplayName().."\"")
										end
									end,
								};
								SCREENMAN:GetTopScreen():Load(searchSettings);
							end;
						else
							WriteFile("ThemeSlot"..i..".cfg",ColorToSave,"Settings/ThemeSlots "..ProfileName:GetDisplayName())
							MESSAGEMAN:Broadcast("ThemeSlotSaved")
							SCREENMAN:SystemMessage("Color \""..ColorToSave.."\" saved on Slot #"..string.format("%02.f",i).." succesfully for Profile \""..ProfileName:GetDisplayName().."\"")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: ThemeColorDel
-------------------------------------------------------------------------------------------------------------------
function OptionRowThemeColorDel()
	local options = {}
	for i = 1,16 do options[#options+1] = s..'DELETE SLOT #'..string.format("%02.f",i) end
	local t = {
		Name = "OptionRowThemeColorDel",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = options,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			local ProfileName = PROFILEMAN:GetProfile(pn)
			for i = 1,16 do
				if list[i] then
					if PROFILEMAN:GetNumLocalProfiles() == 0 then
						local GenericSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots Generic")
						if GenericSlot == "EMPTY" then
							SCREENMAN:SystemMessage("Color Slot #"..string.format("%02.f",i).." from Generic Profile is already empty.")
						else
							WriteFile("ThemeSlot"..i..".cfg","EMPTY","Settings/ThemeSlots Generic")
							SCREENMAN:SystemMessage("Color Slot #"..string.format("%02.f",i).." from Generic Profile has been deleted succesfully.")
							MESSAGEMAN:Broadcast("ThemeSlotDeleted")
						end
					else
						local ThemeSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots "..ProfileName:GetDisplayName())
						if ThemeSlot == "EMPTY" then
							SCREENMAN:SystemMessage("Color Slot #"..string.format("%02.f",i).." from Profile \""..ProfileName:GetDisplayName().."\" is already empty.")
						else
							WriteFile("ThemeSlot"..i..".cfg","EMPTY","Settings/ThemeSlots "..ProfileName:GetDisplayName())
							SCREENMAN:SystemMessage("Color Slot #"..string.format("%02.f",i).." from Profile \""..ProfileName:GetDisplayName().."\" has been deleted succesfully.")
							MESSAGEMAN:Broadcast("ThemeSlotDeleted")
						end
					end
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRow: Quit Game
-------------------------------------------------------------------------------------------------------------------
function OptionRowQuitGame()
	local t = {
		Name = "OptionRowQuitGame",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { s..'Back to TITLE MENU', s..'Quit Game' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenTitleMenu") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
			end
			if list[2] then
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenExit") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
			end
		end
	}
	return t
end